///////////////////////////////////////////////////////////////////
//																 //
//		Public MW-520 API										 //
//		~~~~~~~~~~~~~~~~~										 //
//		Motorolla Communications								 //
//																 //
//		This header file can be used (included) by both			 //
//      the DLL and the application attached to the DLL.		 //
//																 //
///////////////////////////////////////////////////////////////////


#ifndef __HWEVNT32_H__
#define __HWEVNT32_H__

#include <windows.h>

#ifdef __cplusplus
extern "C" {
#endif

//////////////////////////////////////////////////////////
// The constant _MAKE_DLL_ is defined in the DLL module.
// This conditional preprocessing enables to use the same 
// header file for both DLL and attached application.
//
#ifdef _MAKE_DLL_
#define LINKDLL __declspec(dllexport)
#else 
#define LINKDLL __declspec(dllimport)
#endif


/////////////////////////////////////////////////////////// 
//	Prototypes of functions for registering Windows
//	16-bit applications on MW-520 system events.
//
LINKDLL WORD RegisterSysEvent(HWND, UINT, WORD);
LINKDLL WORD DeRegisterSysEvent(HWND);
LINKDLL WORD Register_Emg(HWND, UINT);
LINKDLL WORD DeRegister_Emg(HWND);


//////////////////////////////////////////////////////////// 
//	Prototypes of functions for registering Windows
//	32-bit applications on MW-520 system events.
//	These are the dummy functions based on 
//	the same functions without "32" suffix.
//
LINKDLL WORD RegisterSysEvent32(HWND, UINT, WORD);
LINKDLL WORD DeRegisterSysEvent32(HWND);
LINKDLL WORD Register_Emg32(HWND, UINT);
LINKDLL WORD DeRegister_Emg32(HWND);


//////////////////////////////////////////////////////////// 
//	Prototypes of new functions for working with GPIO
//
LINKDLL BOOL ReadGPIOLine(PBYTE pValue, BYTE Line);
LINKDLL BOOL WriteGPIOLine (BYTE Value, BYTE Line);
LINKDLL BOOL ReadGPIO(PBYTE pValue, BYTE Status);
LINKDLL BOOL WriteGPIO(BYTE Value);


LINKDLL BOOL ReadDiamondReg ( WORD RegAddr, BYTE *data);
LINKDLL BOOL WriteDiamondReg( WORD RegAddr, BYTE  data);


//////////////////////////////////////////////////////////// 
//	Prototypes of new functions for registering
//	Windows NT/2000 services.
//
LINKDLL WORD RegisterService(LPCSTR, WORD);
LINKDLL WORD DeRegisterService(LPCSTR);

#ifdef __cplusplus
}
#endif  // extern "C"


////////////////////////////////////////////////////////////
//	These constants must be used for registering 
//	Windows applications.
//
#define EMERGENCY			  0x0100
#define IGNITION_POWER_EVENT  0x0040


////////////////////////////////////////////////////////////
//	These constants must be used for registering 
//	Windows NT/2000 services.
//
#define SERVICE_EMERGENCY			  0x00C6
#define SERVICE_IGNITION_POWER_EVENT  0x00C7
#define SERVICE_ALL_EVENTS			  0x00C8


/////////////////////////////////////////////////
//  Control codes for service notification about 
//  changes in ignition power state.
//
#define SERVICE_IGNITION_POWER_OFF	  0x00C9
#define SERVICE_IGNITION_POWER_ON	  0x00CA


#endif  // __HWEVNT32_H__
